<?php
/*
  $Id$

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2010 osCommerce

  Released under the GNU General Public License
*/

  require("includes/application_top.php");

  if ($cart->count_contents() > 0) {
    include(DIR_WS_CLASSES . 'payment.php');
    $payment_modules = new payment;
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_SHOPPING_CART);

  $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_SHOPPING_CART));

  require(DIR_WS_INCLUDES . 'template_top.php');
?>



<?php
  if ($cart->count_contents() > 0) {
?>

<?php echo tep_draw_form('cart_quantity', tep_href_link(FILENAME_SHOPPING_CART, 'action=update_product')); ?>
<div id="shoppingCartDefault" class="centerColumn">
<header><h4><?php echo HEADING_TITLE; ?></h4></header>
<div class="shopping-cart-page box">
  <div class="table-responsive">

<?php
    $any_out_of_stock = 0;
    $products = $cart->get_products();
    for ($i=0, $n=sizeof($products); $i<$n; $i++) {
// Push all attributes information in an array
      if (isset($products[$i]['attributes']) && is_array($products[$i]['attributes'])) {
        while (list($option, $value) = each($products[$i]['attributes'])) {
          echo tep_draw_hidden_field('id[' . $products[$i]['id'] . '][' . $option . ']', $value);
          $attributes = tep_db_query("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix
                                      from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                      where pa.products_id = '" . (int)$products[$i]['id'] . "'
                                       and pa.options_id = '" . (int)$option . "'
                                       and pa.options_id = popt.products_options_id
                                       and pa.options_values_id = '" . (int)$value . "'
                                       and pa.options_values_id = poval.products_options_values_id
                                       and popt.language_id = '" . (int)$languages_id . "'
                                       and poval.language_id = '" . (int)$languages_id . "'");
          $attributes_values = tep_db_fetch_array($attributes);

          $products[$i][$option]['products_options_name'] = $attributes_values['products_options_name'];
          $products[$i][$option]['options_values_id'] = $value;
          $products[$i][$option]['products_options_values_name'] = $attributes_values['products_options_values_name'];
          $products[$i][$option]['options_values_price'] = $attributes_values['options_values_price'];
          $products[$i][$option]['price_prefix'] = $attributes_values['price_prefix'];
        }
      }
    }
?>

    <table border="0" width="100%" cellspacing="0" cellpadding="10" class="table" id="cartContentsDisplay">
    	<tbody>
        	<tr class="tableHeading">
            	<th><?php echo PRODUCT_TITLE_CART; ?></th>
                <th><?php echo PRODUCT_QTY_CART; ?></th>
                <th><?php echo PRODUCT_UPDATE_CART; ?></th>
				<th><?php echo PRODUCT_REMOVE_CART; ?></th>
                <th><?php echo ENTRY_TOTAL_CART; ?></th>
            </tr>
<?php

    for ($i=0, $n=sizeof($products); $i<$n; $i++) { ?>
     	<tr class="tablecontent">
	    	<td align="center" class="cartProductDisplay" width="20%">
            	<?php
      				if (STOCK_CHECK == 'true') {
        				$stock_check = tep_check_stock($products[$i]['id'], $products[$i]['quantity']);
        					if (tep_not_null($stock_check)) {
          						$any_out_of_stock = 1;
          						$products_name_q = $stock_check;
        					}
      				}
				?>
				<?php 
            		if (isset($products[$i]['attributes']) && is_array($products[$i]['attributes'])) {
						reset($products[$i]['attributes']);
        				while (list($option, $value) = each($products[$i]['attributes'])) {
          					$products[$i]['name'] .= '<br /><small><i> - ' . $products[$i][$option]['products_options_name'] . ' ' . 
							$products[$i][$option]['products_options_values_name'] . '</i></small>';
        				}
      			} ?>
                <span id="cartImage" class="back">
					<?php echo tep_image(DIR_WS_IMAGES . $products[$i]['image'],$products[$i]['name'], SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT); ?>
                    <a href="<?php echo tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $products[$i]['id']);?>">
                    	<?php echo $products[$i]['name'] . $products_name_q; ?>
                    </a>
                </span>
            </td>
      		<td align="center" class="cartQuantity">
				<?php echo tep_draw_input_field('cart_quantity[]', $products[$i]['quantity'], 'size="4"') . tep_draw_hidden_field('products_id[]', $products[$i]['id']); ?>
            </td>
      		<td align="center" class="cartQuantityUpdate">
				<?php echo tep_draw_button(IMAGE_BUTTON_UPDATE_SHOPPING_CART, 'refresh'); ?>
            </td>
      		<td align="center" class="cartRemoveItemDisplay">
                <a href="<?php echo tep_href_link(FILENAME_SHOPPING_CART, 'products_id=' . $products[$i]['id'] . '&action=remove_product'); ?>"><?php echo tep_image(DIR_WS_IMAGES.'cross.png')?></a>
            </td>
      		<td align="center" valign="middle" class="cartTotalDisplay">
				<?php echo $currencies->display_price($products[$i]['final_price'], tep_get_tax_rate($products[$i]['tax_class_id']), $products[$i]['quantity']); ?>
            </td>
       </tr>
   		<?php  }
		?>
        </tbody>
    </table>
</div>
    <div id="cartSubTotal"><?php echo SUB_TITLE_SUB_TOTAL; ?> <?php echo $currencies->format($cart->show_total()); ?>
    </div>

	<?php
    	if ($any_out_of_stock == 1) {
      	if (STOCK_ALLOW_CHECKOUT == 'true') {
	?>
    <p class="stockWarning" align="center"><?php echo OUT_OF_STOCK_CAN_CHECKOUT; ?></p>
	<?php
      } else {
	?>
    <p class="stockWarning" align="center"><?php echo OUT_OF_STOCK_CANT_CHECKOUT; ?></p>
	<?php
     	 }
    	}
	?>
    <br class="clearBoth">
    <div class="buttonSet">
        <span class="cart-buttons ckpc">
			<?php echo tep_draw_button(IMAGE_BUTTON_CHECKOUT, 'triangle-1-e', tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'), 'primary'); ?>
        </span>
        <?php
        $initialize_checkout_methods = $payment_modules->checkout_initialization_method();
        if (!empty($initialize_checkout_methods)) {
          reset($initialize_checkout_methods);
          while (list(, $value) = each($initialize_checkout_methods)) { ?>
         <span class="alternate_text"><?php echo TEXT_ALTERNATIVE_CHECKOUT_METHODS; ?> </span>
         <span class="other_options"> <?php echo $value; ?></span>
         <?php  }
        }
    ?>
	</div>
</div>
  


</div>
</div>
</form>
<?php
  } else {
?>
<div id="shoppingCartDefault" class="centerColumn">
	<h2 id="crtempty"><?php echo TEXT_CART_EMPTY; ?></h2>
</div>
<?php
  }

  require(DIR_WS_INCLUDES . 'template_bottom.php');
  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>
